#include <bits/stdc++.h>

using namespace std;

typedef long long llint;

const int MAXN = 15;
const llint INF = 5e18;

int n;
int x[MAXN], y[MAXN];

vector<pair<int, llint>> a;

llint memo[MAXN * (MAXN - 1) * (MAXN - 2) / 6 + 10][1 << MAXN];

llint dp(int i, int mask) {
  if (memo[i][mask] != -1) return memo[i][mask];
  if (mask == (1 << n) - 1) return memo[i][mask] = 0;
  if (i == (int) a.size()) return memo[i][mask] = INF;
  return memo[i][mask] = min(dp(i + 1, mask),
                             dp(i + 1, mask | a[i].first) + a[i].second);
}

llint area(int i, int j, int k) {
  return abs((llint)x[i] * (y[j] - y[k]) + (llint)x[j] * (y[k] - y[i]) +
             (llint)x[k] * (y[i] - y[j]));
}

int main(void) {
  scanf("%d", &n);
  assert(n <= 15);
  for (int i = 0; i < n; ++i) scanf("%d%d", &x[i], &y[i]);

  for (int i = 0; i < n; ++i)
    for (int j = i + 1; j < n; ++j)
      for (int k = j + 1; k < n; ++k)
        a.emplace_back((1 << i) | (1 << j) | (1 << k), area(i, j, k));

  memset(memo, -1, sizeof memo);
  printf("%.8Lf\n", (long double)dp(0, 0) / 2);
  return 0;
}
